<?php
// config/config.php
declare(strict_types=1);

return [
    'app_name' => 'SCALIA Inventario & Cotizaciones',
    'base_url' => getenv('APP_BASE_URL') ?: '',
    'db' => [
        'host' => getenv('DB_HOST') ?: '127.0.0.1',
        'port' => (int)(getenv('DB_PORT') ?: 3306),
        'name' => getenv('DB_NAME') ?: 'scalia_inventario',
        'user' => getenv('DB_USER') ?: 'root',
        'pass' => getenv('DB_PASS') ?: '',
        'charset' => 'utf8mb4'
    ],
    // Default company profile (can be edited from Settings later)
    'company' => [
        'name' => 'SCALIA Security & Wellness Integration',
        'logo' => '/public/assets/img/scalia_logo.svg',
        'address' => 'Calle 3 Sur 5965_6, El Cerrito, 72440 Heroica Puebla de Zaragoza, Pue.',
        'phone' => '+52 2212.03.16.36',
        'email' => 'ventas@scalia.mx',
        'rfc' => 'XAXX010101000'
    ]
];
