<?php
// app/views/quotes/print.php (muestra instalación e insumos en PDF)
?><!doctype html>
<html lang="es">
<head>
  <meta charset="utf-8">
  <title>Cotización #<?= (int)$quote['id'] ?></title>
  <link rel="stylesheet" href="/assets/css/app.css">
  <style>
    body { background: #fff; color: #000; }
    .muted { color: #555; }
    .print-card { border:1px solid #ccc; padding:12px; margin-bottom:10px; }
  </style>
</head>
<body class="print-container">
  <div class="row">
    <div class="col-6">
      <img src="<?= htmlspecialchars($company['logo']) ?>" alt="SCALIA" height="40"><br>
      <strong><?= htmlspecialchars($company['name']) ?></strong><br>
      <span class="muted"><?= htmlspecialchars($company['address']) ?></span><br>
      <span class="muted"><?= htmlspecialchars($company['email']) ?> · <?= htmlspecialchars($company['phone']) ?></span>
    </div>
    <div class="col-6" style="text-align:right">
      <strong>Cotización</strong><br>
      Folio: #<?= (int)$quote['id'] ?><br>
      Fecha: <?= htmlspecialchars(substr($quote['created_at'],0,10)) ?>
    </div>
  </div>

  <div class="row" style="margin-top:10px">
    <div class="col-6">
      <strong>Cliente</strong><br>
      <?php if(!empty($quote['client_name'])): ?>
        <div><strong><?= htmlspecialchars($quote['client_name']) ?></strong><?= $quote['company'] ? ' — '.htmlspecialchars($quote['company']) : '' ?></div>
        <div class="muted"><?= htmlspecialchars($quote['email'] ?: '') ?> <?= htmlspecialchars($quote['phone'] ? ' · '.$quote['phone'] : '') ?></div>
        <div class="muted"><?= htmlspecialchars($quote['address'] ?: '') ?></div>
      <?php else: ?>
        <?= htmlspecialchars($quote['customer']) ?>
      <?php endif; ?>
    </div>
    <div class="col-6" style="text-align:right">
      <strong>Atención</strong><br>
      <?= htmlspecialchars($quote['user_name']) ?>
    </div>
  </div>

  <div class="print-card">
    <table style="width:100%; border-collapse:collapse" border="1" cellpadding="6">
      <thead><tr><th>SKU</th><th>Producto</th><th style="text-align:right">Cantidad</th><th style="text-align:right">Precio</th><th style="text-align:right">Importe</th></tr></thead>
      <tbody>
      <?php $subtotal = 0.0; foreach($items as $it): $imp = (float)$it['price'] * (int)$it['qty']; $subtotal += $imp; ?>
        <tr>
          <td><?= htmlspecialchars($it['sku']) ?></td>
          <td><?= htmlspecialchars($it['name']) ?></td>
          <td style="text-align:right"><?= (int)$it['qty'] ?></td>
          <td style="text-align:right">$<?= number_format((float)$it['price'], 2) ?></td>
          <td style="text-align:right">$<?= number_format($imp, 2) ?></td>
        </tr>
      <?php endforeach; ?>
      </tbody>
    </table>
  </div>

  <?php $inst = (float)($quote['installation_cost'] ?? 0); $supp = (float)($quote['supplies_cost'] ?? 0); ?>
  <?php if(!empty($quote['supplies_desc']) || $supp > 0): ?>
  <div class="print-card">
    <strong>Insumos / Consumibles</strong><br>
    <?php if(!empty($quote['supplies_desc'])): ?><div class="muted"><?= nl2br(htmlspecialchars($quote['supplies_desc'])) ?></div><?php endif; ?>
    <div><strong>Costo:</strong> $<?= number_format($supp, 2) ?></div>
  </div>
  <?php endif; ?>

  <?php if(!empty($quote['installation_desc']) || $inst > 0): ?>
  <div class="print-card">
    <strong>Instalación</strong><br>
    <?php if(!empty($quote['installation_desc'])): ?><div class="muted"><?= nl2br(htmlspecialchars($quote['installation_desc'])) ?></div><?php endif; ?>
    <div><strong>Costo:</strong> $<?= number_format($inst, 2) ?></div>
  </div>
  <?php endif; ?>


  <div class="print-card" style="text-align:right">
    <div>Subtotal productos: <strong>$<?= number_format($subtotal, 2) ?></strong></div>
    <?php if($supp>0): ?><div>Insumos: <strong>$<?= number_format($supp, 2) ?></strong></div><?php endif; ?>
    <?php if($inst>0): ?><div>Instalación: <strong>$<?= number_format($inst, 2) ?></strong></div><?php endif; ?>   
    <hr>
    <div class="h5">Total: <strong>$<?= number_format((float)$quote['total'], 2) ?></strong></div>
  </div>
</body>
</html>