<?php
// app/views/quotes/index.php (agrega botón Editar)
?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h4>Cotizaciones</h4>
  <a class="btn btn-primary" href="?r=quotes_create">Nueva cotización</a>
</div>

<form class="row g-2 mb-3">
  <input type="hidden" name="r" value="quotes">
  <div class="col-md-4">
    <select class="form-select" name="client_id">
      <option value="">— Filtrar por cliente —</option>
      <?php foreach(($clientsFilter ?? []) as $cl): ?>
        <option value="<?= (int)$cl['id'] ?>" <?= (isset($_GET['client_id']) && (int)$_GET['client_id']===(int)$cl['id'])?'selected':'' ?>>
          <?= htmlspecialchars($cl['name']) ?><?= !empty($cl['company']) ? ' — '.htmlspecialchars($cl['company']) : '' ?>
        </option>
      <?php endforeach; ?>
    </select>
  </div>
  <div class="col-md-4">
    <input class="form-control" name="q" placeholder="Buscar por folio o nombre" value="<?= htmlspecialchars($_GET['q'] ?? '') ?>">
  </div>
  <div class="col-md-2">
    <button class="btn btn-outline-primary w-100">Aplicar</button>
  </div>
  <div class="col-md-2">
    <a class="btn btn-outline-secondary w-100" href="?r=quotes">Limpiar</a>
  </div>
</form>

<div class="card p-2">
  <div class="table-responsive">
  <table class="table table-striped align-middle">
    <thead><tr><th>ID</th><th>Cliente</th><th>Creado por</th><th>Fecha</th><th class="text-end">Total</th><th class="text-end">Acciones</th></tr></thead>
    <tbody>
    <?php foreach($quotes as $q): ?>
      <tr>
        <td>#<?= (int)$q['id'] ?></td>
        <td><?= htmlspecialchars($q['client_name'] ?? $q['customer']) ?></td>
        <td><?= htmlspecialchars($q['user_name']) ?></td>
        <td><?= htmlspecialchars($q['created_at']) ?></td>
        <td class="text-end">$<?= number_format((float)$q['total'], 2) ?></td>
        <td class="text-end">
          <a class="btn btn-sm btn-outline-secondary" href="?r=quotes_view&id=<?= (int)$q['id'] ?>">Ver</a>
          <a class="btn btn-sm btn-warning" href="?r=quotes_edit&id=<?= (int)$q['id'] ?>">Editar</a>
          <a class="btn btn-sm btn-primary" href="?r=quotes_print&id=<?= (int)$q['id'] ?>" target="_blank">PDF</a>
        </td>
      </tr>
    <?php endforeach; ?>
    </tbody>
  </table>
  </div>
</div>