<?php
// app/views/products/edit.php (categoría como lista fija)
$cats = ['CCTV','Control de Acceso','Alarma de Intrusión','Domotica','Servicio'];
?>
<h4>Editar producto</h4>
<div class="card p-3">
<form action="?r=products_update" method="post" class="row g-3">
  <input type="hidden" name="id" value="<?= (int)$product['id'] ?>">
  <div class="col-md-6">
    <label class="form-label">Nombre</label>
    <input class="form-control" name="name" value="<?= htmlspecialchars($product['name']) ?>" required>
  </div>
  <div class="col-md-6">
    <label class="form-label">Categoría</label>
    <select class="form-select" name="category" required>
      <?php foreach($cats as $cat): ?>
        <option value="<?= htmlspecialchars($cat) ?>" <?= ($product['category'] === $cat) ? 'selected' : '' ?>><?= htmlspecialchars($cat) ?></option>
      <?php endforeach; ?>
    </select>
  </div>
  <div class="col-12">
    <label class="form-label">Descripción</label>
    <textarea class="form-control" name="description" rows="3"><?= htmlspecialchars($product['description']) ?></textarea>
  </div>
  <div class="col-md-4">
    <label class="form-label">Precio (MXN)</label>
    <input type="number" step="0.01" class="form-control" name="price" value="<?= (float)$product['price'] ?>" required>
  </div>
  <div class="col-md-4">
    <label class="form-label">Stock</label>
    <input type="number" class="form-control" name="stock" value="<?= (int)$product['stock'] ?>" required>
  </div>
  <div class="col-12">
    <button class="btn btn-primary">Actualizar</button>
    <a class="btn btn-outline-secondary" href="?r=products">Cancelar</a>
  </div>
</form>
</div>