<?php
// app/controllers/UserController.php
declare(strict_types=1);

class UserController {
    public function __construct(private PDO $db, private array $config) {}

    public function index(): void {
        $stmt = $this->db->query("SELECT id, name, email, role, created_at FROM users ORDER BY id DESC");
        $users = $stmt->fetchAll();
        $title = 'Usuarios';
        require __DIR__ . '/../views/partials/header.php';
        require __DIR__ . '/../views/users/index.php';
        require __DIR__ . '/../views/partials/footer.php';
    }

    public function create(): void {
        $title = 'Nuevo usuario';
        require __DIR__ . '/../views/partials/header.php';
        require __DIR__ . '/../views/users/create.php';
        require __DIR__ . '/../views/partials/footer.php';
    }

    public function store(): void {
        $name = trim($_POST['name'] ?? '');
        $email = trim($_POST['email'] ?? '');
        $role = $_POST['role'] ?? 'tech';
        $password = $_POST['password'] ?? '';
        $role = in_array($role, ['admin','tech'], true) ? $role : 'tech';
        $hash = password_hash($password, PASSWORD_DEFAULT);

        $stmt = $this->db->prepare("INSERT INTO users (name, email, role, password_hash) VALUES (?,?,?,?)");
        $stmt->execute([$name, $email, $role, $hash]);
        header('Location: ?r=users'); exit;
    }
}
