<?php
// app/controllers/ProductController.php
declare(strict_types=1);

class ProductController {
    public function __construct(private PDO $db, private array $config) {}

    public function index(): void {
        $q = trim($_GET['q'] ?? '');
        if ($q !== '') {
            $stmt = $this->db->prepare("SELECT * FROM products WHERE name LIKE ? OR sku LIKE ? ORDER BY id DESC");
            $like = "%$q%";
            $stmt->execute([$like, $like]);
        } else {
            $stmt = $this->db->query("SELECT * FROM products ORDER BY id DESC");
        }
        $products = $stmt->fetchAll();
        $title = 'Productos';
        require __DIR__ . '/../views/partials/header.php';
        require __DIR__ . '/../views/products/index.php';
        require __DIR__ . '/../views/partials/footer.php';
    }

    public function create(): void {
        $title = 'Nuevo producto';
        require __DIR__ . '/../views/partials/header.php';
        require __DIR__ . '/../views/products/create.php';
        require __DIR__ . '/../views/partials/footer.php';
    }

    public function store(): void {
        $name = trim($_POST['name'] ?? '');
        $desc = trim($_POST['description'] ?? '');
        $category = trim($_POST['category'] ?? '');
        $price = (float)($_POST['price'] ?? 0);
        $stock = (int)($_POST['stock'] ?? 0);
        $sku = strtoupper(bin2hex(random_bytes(4))); // 8 hex chars

        $stmt = $this->db->prepare("INSERT INTO products (sku, name, description, category, price, stock, created_by) VALUES (?,?,?,?,?,?,?)");
        $stmt->execute([$sku, $name, $desc, $category, $price, $stock, $_SESSION['user']['id']]);

        header('Location: ?r=products'); exit;
    }

    public function edit(): void {
        $id = (int)($_GET['id'] ?? 0);
        $stmt = $this->db->prepare("SELECT * FROM products WHERE id = ?");
        $stmt->execute([$id]);
        $product = $stmt->fetch();
        if (!$product) { http_response_code(404); echo 'Producto no encontrado'; return; }
        $title = 'Editar producto';
        require __DIR__ . '/../views/partials/header.php';
        require __DIR__ . '/../views/products/edit.php';
        require __DIR__ . '/../views/partials/footer.php';
    }

    public function update(): void {
        $id = (int)($_POST['id'] ?? 0);
        $name = trim($_POST['name'] ?? '');
        $desc = trim($_POST['description'] ?? '');
        $category = trim($_POST['category'] ?? '');
        $price = (float)($_POST['price'] ?? 0);
        $stock = (int)($_POST['stock'] ?? 0);

        $stmt = $this->db->prepare("UPDATE products SET name=?, description=?, category=?, price=?, stock=? WHERE id=?");
        $stmt->execute([$name, $desc, $category, $price, $stock, $id]);
        header('Location: ?r=products'); exit;
    }

    public function delete(): void {
        $id = (int)($_GET['id'] ?? 0);
        $stmt = $this->db->prepare("DELETE FROM products WHERE id = ?");
        $stmt->execute([$id]);
        header('Location: ?r=products'); exit;
    }
}
