<?php
// app/controllers/ClientController.php
declare(strict_types=1);
class ClientController {
    public function __construct(private PDO $db, private array $config) {}

    public function index(): void {
        $q = trim($_GET['q'] ?? '');
        if ($q !== '') {
            $stmt = $this->db->prepare("SELECT * FROM clients WHERE name LIKE ? OR company LIKE ? OR email LIKE ? ORDER BY id DESC");
            $like = "%$q%";
            $stmt->execute([$like, $like, $like]);
        } else {
            $stmt = $this->db->query("SELECT * FROM clients ORDER BY id DESC");
        }
        $clients = $stmt->fetchAll();
        $title = 'Clientes';
        require __DIR__ . '/../views/partials/header.php';
        require __DIR__ . '/../views/clients/index.php';
        require __DIR__ . '/../views/partials/footer.php';
    }

    public function create(): void {
        $title = 'Nuevo cliente';
        require __DIR__ . '/../views/partials/header.php';
        require __DIR__ . '/../views/clients/create.php';
        require __DIR__ . '/../views/partials/footer.php';
    }

    public function store(): void {
        $name = trim($_POST['name'] ?? '');
        $company = trim($_POST['company'] ?? '');
        $email = trim($_POST['email'] ?? '');
        $phone = trim($_POST['phone'] ?? '');
        $address = trim($_POST['address'] ?? '');
        $stmt = $this->db->prepare("INSERT INTO clients (name, company, email, phone, address) VALUES (?,?,?,?,?)");
        $stmt->execute([$name, $company, $email, $phone, $address]);
        header('Location: ?r=clients'); exit;
    }

    public function edit(): void {
        $id = (int)($_GET['id'] ?? 0);
        $stmt = $this->db->prepare("SELECT * FROM clients WHERE id = ?");
        $stmt->execute([$id]);
        $client = $stmt->fetch();
        if (!$client) { http_response_code(404); echo 'Cliente no encontrado'; return; }
        $title = 'Editar cliente';
        require __DIR__ . '/../views/partials/header.php';
        require __DIR__ . '/../views/clients/edit.php';
        require __DIR__ . '/../views/partials/footer.php';
    }

    public function update(): void {
        $id = (int)($_POST['id'] ?? 0);
        $name = trim($_POST['name'] ?? '');
        $company = trim($_POST['company'] ?? '');
        $email = trim($_POST['email'] ?? '');
        $phone = trim($_POST['phone'] ?? '');
        $address = trim($_POST['address'] ?? '');
        $stmt = $this->db->prepare("UPDATE clients SET name=?, company=?, email=?, phone=?, address=? WHERE id=?");
        $stmt->execute([$name, $company, $email, $phone, $address, $id]);
        header('Location: ?r=clients'); exit;
    }

    public function delete(): void {
        $id = (int)($_GET['id'] ?? 0);
        $stmt = $this->db->prepare("DELETE FROM clients WHERE id = ?");
        $stmt->execute([$id]);
        header('Location: ?r=clients'); exit;
    }
}
